*******************************************************************************
*                         680xx Grundprogramm drmenue                         *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                               Druckermen                                   *
*******************************************************************************


druckmen:                       * Druckersteuerung
 lea drtxt0(pc),a0
 bsr headaclr                   * berschrift
 lea drtxt1(pc),a0
 moveq #$21,d0
 moveq #5,d1
 move #207,d2
 bsr textprint                  * Befehlsliste
 bsr.s drall                    * Aktuelle Einstellungen
drmen0:
 lea einbuf(a5),a0
 moveq #$21,d0
 moveq #5,d1
 moveq #4,d2
 moveq #1,d3                    * Nur ein Zeichen
 bsr textein                    * Befehl einlesen
 bcs carset                     * Abbruch
 move d5,d0
 bsr bucheck                    * In Grobuchstaben wandeln
 cmp.b #'Z',d0
 beq carset                     * 'Z' = Zurck
 cmp.b #'A',d0                  * Bereich 'A'
 bmi.s drmen0
 cmp.b #'S',d0                  * bis 'S'
 bhi.s drmen0
 add d0,d0
 move drucktab-2*'A'(pc,d0.w),d1
 jsr drucktab(pc,d1.w)          * Befehl ausfhren
bra.s drmen0

drucktab:                       * Tabelle der Befehle zur Druckereinstellung
 dc.w drmena-drucktab           * Seitenlnge
 dc.w drmenb-drucktab           * Linker Rand
 dc.w drmenc-drucktab           * Druckart
 dc.w drmend-drucktab           * Schriftart
 dc.w drmene-drucktab           * Druck
 dc.w drmenf-drucktab           * Langsamer Druck
 dc.w drmeng-drucktab           * Fettdruck
 dc.w drmenh-drucktab           * Doppeldruck
 dc.w drmeni-drucktab           * Proportionaldruck
 dc.w drmenj-drucktab           * Kursivdruck
 dc.w drmenk-drucktab           * Papiererkennung
 dc.w drmenl-drucktab           * Zeichensatz
 dc.w drmenm-drucktab           * Kopienanzahl
 dc.w drmenn-drucktab           * Eigene Befehle
 dc.w drmeno-drucktab           * Werte rcksetzen
 dc.w initdr-drucktab           * Druckerinit
 dc.w drmenq-drucktab           * Seitenvorschub
 dc.w drmenr-drucktab           * Ausdrucken
 dc.w drbefneu-drucktab         * Druckerbefehle ndern

drmeno:                         * Werte rcksetzen
 move.b #2,dflag0(a5)
 clr.b dflag1(a5)
 move.b #65,dflag2(a5)
 clr.b dflag3(a5)

drall:                          * Druckereinstellungen ausgeben
 bsr.s drmenaa
 bsr.s drmenba
 bsr drmenca
 bsr drmenda
 bsr drmenea
 bsr drmenfa
 bsr drmenga
 bsr drmenha
 bsr drmenia
 bsr drmenja
 bsr drmenka
 bsr drmenla
 bsr drmenma
bra drmenna

drmena:                         * Seitenlnge
 addq.b #1,dflag2(a5)           * + 1
 and.b #$7f,dflag2(a5)          * Bis 127
 bne.s drmenaa
 addq.b #5,dflag2(a5)           * Von 5 an
drmenaa:
 moveq #0,d0
 move.b dflag2(a5),d0
 moveq #1,d2                    * Zeile 1
drmenab:
 lea ausbuf(a5),a0
 bsr print4d                    * In ASCII wandeln
 move.b #' ',(a0)+
 move.b #' ',(a0)+              * Falls Wechsel von 127 auf 5
 clr.b (a0)                     * Endekennung
 lea ausbuf(a5),a0
bra draus                       * Ausgeben

drmenb:                         * Linker Rand
 addq.b #1,dflag3(a5)           * + 1
 and.b #$7f,dflag3(a5)          * Bereich 0 bis 127
drmenba:
 moveq #0,d0
 move.b dflag3(a5),d0
 moveq #2,d2                    * Zeile 2
bra.s drmenab

drmenc:                         * Druckart
 btst.b #1,dflag1(a5)           * Drei Mglichkeiten (%00,%01,%10)
 beq.s drmenc0
 and.b #$fc,dflag1(a5)          * Nach %11 kommt wieder %00
bra.s drmenca
drmenc0:
 addq.b #1,dflag1(a5)           * Sonst 1 weiter
drmenca:
 lea drtxtc(pc),a0
 move.b dflag1(a5),d0
 and #3,d0                      * Bit 0 und 1
 mulu #7,d0                     * Jeweils 7 Buchstaben
 moveq #3,d2                    * Zeile 3
bra drausadd

drmend:                         * Schriftart
 bchg.b #2,dflag1(a5)           * Bit 2 bestimmt sie
drmenda:
 lea drtxtd(pc),a0
 move.b dflag1(a5),d0
 lsr #2,d0
 and #1,d0
 mulu #6,d0
 moveq #4,d2                    * Zeile 4
bra drausadd

drmene:                         * Druck
 bchg.b #3,dflag1(a5)           * Bit 3
drmenea:
 lea drtxte(pc),a0
 move.b dflag1(a5),d0
 lsr #3,d0
 and #1,d0
 mulu #15,d0
 moveq #5,d2                    * Zeile 5
bra drausadd

drmenf:                         * Langsamer Druck
 bchg.b #4,dflag1(a5)           * Bit 4
drmenfa:
 move.b dflag1(a5),d0
 lsr #2,d0
 moveq #6,d2                    * Zeile 6
bra drausand

drmeng:                         * Fettdruck
 bchg.b #7,dflag0(a5)           * Bit 7
drmenga:
 move.b dflag0(a5),d0
 lsr #5,d0
 moveq #7,d2                    * Zeile 7
bra drausand

drmenh:                         * Doppeldruck
 bchg.b #6,dflag0(a5)           * Bit 6
drmenha:
 move.b dflag0(a5),d0
 lsr #4,d0
 moveq #8,d2                    * Zeile 8
bra drausand

drmeni:                         * Proportionaldruck
 bchg.b #5,dflag0(a5)           * Bit 8
drmenia:
 move.b dflag0(a5),d0
 lsr #3,d0
 moveq #9,d2                    * Zeile 9
bra drausand

drmenj:                         * Kursivdruck
 bchg.b #4,dflag0(a5)           * Bit 4
drmenja:
 move.b dflag0(a5),d0
 lsr #2,d0
 moveq #10,d2                   * Zeile 10
bra.s drausand

drmenk:                         * Papiererkennung
 bchg.b #3,dflag0(a5)           * Bit 3
drmenka:
 move.b dflag0(a5),d0
 lsr #1,d0
 bchg   #2,d0                   * Wechseln, da AN/AUS vertauscht
 moveq #11,d2                   * Zeile 11
bra.s drausand

drmenl:                         * Zeichensatz (%00,%01,%10)
 btst.b #1,dflag0(a5)           * Bit 1
 bne.s drmenl0
 addq.b #1,dflag0(a5)           * + 1
bra.s drmenla
drmenl0:
 and.b #$fc,dflag0(a5)          * Von %10 Wechsel auf %00
drmenla:
 lea drtxtl(pc),a0
 move.b dflag0(a5),d0
 and #3,d0
 mulu #13,d0
 moveq #12,d2                   * Zeile 12
bra.s drausadd

drmenm:                         * Anzahl Kopien
 cmp.b #%11011111,dflag1(a5)    * Bit 5-7
 bhi.s drmenm0                  * Wert ist 7
 add.b #%00100000,dflag1(a5)    * Nicht 7, also plus 1
bra.s drmenma
drmenm0:
 and.b #%00011111,dflag1(a5)    * Von 7 auf 0
drmenma:
 moveq #0,d0
 move.b dflag1(a5),d0
 lsr #5,d0
 lea ausbuf(a5),a0
 bsr print4d
 lea ausbuf(a5),a0
 moveq #13,d2
bra.s draus

drausand:                       * Ausgabe mit Addition d0,a0
 lea    drtxtf(pc),a0           * Text AN/AUS
 and #%00000100,d0              * Nur Bit 2 behalten ( Entweder Null oder 4 )
drausadd:                       * Nur Addition
 adda d0,a0

draus:                          * Info ausgeben d2 ist Zeile
 muls #-10,d2                   * Zeilenabstand
 add #217,d2                    * Berechnung oberste Zeile
 move #320,d1                   * X-Position
 moveq #$21,d0                  * Zeichengre
bra textaus                     * Text ausgeben

drmenn:
 lea drsave(a5),a1              * Ziel fr Befehle
 moveq #53,d6                   * X
 moveq #77,d2                   * Y
 moveq #3,d3                    * Anzahl der Zeichen maximal
 moveq #19-1,d7                 * Maximal 20 Zeichen
drmenn0:
 lea einbuf(a5),a0
 moveq #$11,d0
 move d6,d1
 bsr textein                    * Zeichen lesen
 bcs.s drmenn1                  * Ende
 tst d4
 beq.s drmenn1                  * Ende
 lea einbuf(a5),a0
 bsr wertmfeh                   * Wert berechnen
 bcs.s drmenn0                  * Fehler, noch einmal eingeben
 move.b d0,(a1)+                * Wert ablegen
 add #24,d6                     * Neue Position
dbra d7,drmenn0
drmenn1:
 st (a1)                        * Endekennung

drmenna:                        * Ausgabe der selbstdefinierten Befehle
 moveq #$11,d0                  * Schriftgre
 moveq #53,d1                   * X-Position
 moveq #77,d2                   * Y-Position
 bsr setprt                     * Werte einstellen
 bsr erapen                     * Auf Lschen
 moveq #%1010,d0                * Befehl fr Block
 moveq #76,d7                   * 30 Zeichen lschen
drmenna0:
 bsr cmd                        * Befehl an GDP
dbra d7,drmenna0
 bsr setpen
 lea drsave(a5),a1              * Dort stehen Druckerbefehle
drmenna1:
 lea ausbuf(a5),a0
 move.b (a1)+,d0                * Befehle holen
 cmp.b #$ff,d0                  * $ff ist Ende
 beq.s drmenna2
 bsr print2x                    * In hexadezimal wandeln
 lea ausbuf(a5),a0
 moveq #$11,d0
 bsr textprint                  * Zeichen ausgeben
 add #24,d1                     * Nchste Position
bra.s drmenna1                  * Wiederholen
drmenna2:
rts                             * Ende

drmenq:                         * Seitenvorschub
 moveq #$c,d0
bra lo2

drmenr:                         * Editor ausdrucken
 moveq #0,d2
 move.b dflag1(a5),d2
 lsr #5,d2                      * 3 Bit fr Anzahl
bra.s drmenr1
drmenr0:
 tst d3                         * Zeile Null ?
 beq.s drmenr1                  * Ja, dann kein Seitenvorschub
 bsr.s drmenq                   * Seitenvorschub
drmenr1:
 moveq #0,d3                    * Zeile Null
 movea.l stxtxt(a5),a1          * Anfangsadresse
drmenr2:
 move.b (a1)+,d1                * Zeichen holen
 beq.s drmenr5                  * Null ist Ende
 cmp.b #$a,d1                   * Linefeed ?
 bne.s drmenr3                  * Nein
 addq #1,d3                     * Nchste Zeile erreicht
 cmp.b dflag2(a5),d3            * Ende der Seite erreicht ?
 bne.s drmenr3                  * Nein, dann nur Linefeed ausfhren
 clr d3
 bsr.s drmenq                   * Ja, Seitenvorschub ausfhren
bra.s drmenr2                   * Nchstes Zeichen
drmenr3:
 bsr csts                       * Zeichen von Tastatur ?
 beq.s drmenr4                  * Nein !!!
 bsr ci                         * Zeichen holen
 cmp.b #$1b,d0
 beq carset                     * ESC = Abbruch
drmenr4:
 bsr lsts
 beq.s drmenr3                  * Warten bis Drucker fertig
 move.b d1,d0                   * Auszugebendes Zeichen
 bsr lo                         * Zeichen ausgeben
bra.s drmenr2                   * Nchstes Zeichen
drmenr5:
dbra d2,drmenr0                 * Kopien
bra carres

drbefneu:                       * Druckerbefehle ndern
 addq.l #4,a7                   * Rcksprungadresse lschen
 bsr clrall                     * Bildschirm lschen
drbefn0:
 lea drtxt2(pc),a0              * Ausgabetext
 moveq #$21,d0
 moveq #2,d1
 move #245,d2
 bsr textprint
 lea drbeftab(a5),a1            * Tabelle der Druckerbefehle
 move #245,d2                   * Anfangs Y-Position
 move #360,d1                   * X-Position
 moveq #22-1,d7                 * Anzahl der Befehle
drbefn1:
 movea.l a1,a2                  * Adresse merken
 lea ausbuf(a5),a0              * Ziel
 move.l #'    ',(a0)+           * Vorlschen
 move.l #'    ',(a0)+
 move.l #'    ',(a0)+
 clr.b (a0)
 lea ausbuf(a5),a0              * Ziel
 moveq #3-1,d6                  * Maximal 3 Bytes pro Befehl
drbefn2:
 move.b (a2)+,d0                * Byte holen
 bmi.s drbefn3                  * Negativ, dann Ende
 bsr print2x                    * In ASCII wandeln
 move.b #' ',(a0)               * Null am Ende berschreiben
 addq.l #2,a0                   * Zieladresse erhhen
dbra d6,drbefn2
drbefn3:
 addq.l #3,a1                   * Adresse nchster Befehl
 moveq #$21,d0
 lea ausbuf(a5),a0
 bsr textaus                    * Text ausgeben
 sub #10,d2                     * Nchste Y-Position
dbra d7,drbefn1
drbefn4:
 lea einbuf(a5),a0
 moveq #$21,d0
 moveq #2,d1
 moveq #2,d2
 moveq #1,d3                    * Nur 1 Zeichen
 bsr textein                    * Befehl einlesen
 bcs druckmen                   * Abbruch
 move d5,d0
 bsr bucheck                    * In Grobuchstaben wandeln
 cmp.b #'Z',d0
 beq druckmen                   * 'Z' = Zurck
 cmp.b #'W',d0
 bne.s drbefn5                  * 'W' = Druckbefehle initialisieren
 bsr drbefinit
bra drbefn0
drbefn5:
 cmp.b #'A',d0                  * Bereich 'A'
 bmi.s drbefn4
 cmp.b #'V',d0                  * bis 'V'
 bhi.s drbefn4
 move d0,d2                     * Merken fr Y-Position
 mulu #3,d0                     * 3 Bytes pro Befehl
 lea drbeftab-3*'A'(a5),a4      * Tabelle der Befehle
 adda.l d0,a4                   * Ablageadresse errechnet
 muls #-10,d2                   * Zeilenabstand
 add #245+10*'A',d2             * Oberste Zeile
 move #360,d6                   * X-Position
 moveq #3-1,d7
drbefn6:
 moveq #$21,d0                  * Schriftgre
 move d6,d1
 moveq #3,d3                    * Maximal 3 Zeichen
 lea einbuf(a5),a0
 bsr textein                    * Zeichen einlesen
 bcs.s drbefn7                  * Abbruch
 tst d4
 beq.s drbefn7                  * Wenn kein Zeichen, dann Ende
 lea einbuf(a5),a0
 bsr wertmfeh                   * Wert berechnen
 bcs.s drbefn6                  * Fehler, noch einmal lesen
 tst d0
 bmi.s drbefn6                  * Negative Werte sind nicht erlaubt
 move.b d0,(a4)+                * Im Speicher ablegen
 add #12*4,d6                   * Nchste X-Position
dbra d7,drbefn6
bra drbefn0
drbefn7:
 st (a4)                        * Endekennung, da nicht 3 Zeichen
bra drbefn0

                                                                                                                                            b 'PRINT8B '                * 45
 dc.b 'PRINT4D '                * 46
 dc.b 'HIDE    '                * 47
 dc.b 'SHOW    '                * 48
 dc.b 'CRT     '                * 49
 dc.b 'LST     '                * 50
 dc.b 'USR     '                * 51
 dc.b 'NIL     '                * 52
 dc.b 'SETERR  '                * 53
 dc.b 'GETERR  '                * 54
 dc.b 'SETPASS '                * 55
 dc.b 'EDIT    '                * 56
 dc.b 'FIGUR   '                * 57
 dc.b 'SETFIG  '      